------------------------------------------------------------------------------
-- Repeat Clip script, Revision: 2.0 
--
-- tool script
--
-- This script will loop or ping-pong a clip in a loader by a specified number of 
-- times by duplicating the clip in a cliplist. The global range of the flow will 
-- be extended to fit the clip if the range is not sufficient. 
--
-- Known Problems
-- Might get confused if the Loader already has a cliplist.
--
-- written by : Peter Loveday 
-- written    : June 6th, 2003
-- updated : Sept 27, 2005
-- changes : updated for 5
------------------------------------------------------------------------------


if not tool then
	print("Error: This script must be run as a Tool Script.")
	return
end

if tool:GetAttrs().TOOLS_RegID ~= "Loader" then
	print("Error: This script can only be run on a Loader tool.")
	return
end

composition:Lock()

options = AskUser("Repeat Clip", {
	{ "Mode", "Dropdown", Options = { "Ping-Pong", "Loop" }  },
	{ "Repeats", "Slider", Min = 1, Max = 100, Integer = true },
	})

if options then
	composition:StartUndo("Repeat Clip")
	
	time = composition.CurrentTime
	
	-- Get info about the current clip
	name       = tool.Clip[time]
	globalin   = tool.GlobalIn[time]
	globalout  = tool.GlobalOut[time]
	reverse    = tool.Reverse[time]
	cliplen    = globalout - globalin + 1
	
	-- trimming will be adjusted for reversed and non-reversed clips differently
	trim = {[0] = {}, [1] = {}}
	
	trim[0].clipstart  = tool.ClipTimeStart[time]
	trim[0].clipend    = tool.ClipTimeEnd[time]
	trim[0].extfirst   = tool.HoldFirstFrame[time]
	trim[0].extlast    = tool.HoldLastFrame[time]

	trim[1].clipstart  = trim[0].clipstart
	trim[1].clipend    = trim[0].clipend  
	trim[1].extfirst   = trim[0].extfirst 
	trim[1].extlast    = trim[0].extlast  	
	                   
	if options.Mode == 0 then  -- ping-pong ?
		cliplen = cliplen - 1
		
		-- Adjust trimming
		if trim[0].extfirst > 0 then
			trim[0].extfirst = trim[0].extfirst - 1
		else
			trim[0].clipstart = trim[0].clipstart + 1
		end
		
		if trim[1].extlast > 0 then
			trim[1].extlast = trim[1].extlast - 1
		else
			trim[1].clipend = trim[1].clipend - 1
		end
	end
	
	-- start right after the clip
	time = globalout + 1
	
	-- Get global end, and extend if we won't fit
	flowglobalend = composition:GetAttrs().COMPN_GlobalEnd
	
	if time + cliplen * options.Repeats > flowglobalend then
		composition:SetAttrs({COMPN_GlobalEnd = time + cliplen * options.Repeats})
	end
	
	for i=1, options.Repeats do
		if options.Mode == 0 then  -- ping-pong ?
			reverse = 1-reverse    -- swap reverse each time
		end
		
		-- Now set the new clip in
		tool.Clip[time]         = name
		tool.Reverse[time]          = reverse
		
		tool.ClipTimeStart[time]    = trim[reverse].clipstart
		tool.ClipTimeEnd[time]      = trim[reverse].clipend
		tool.HoldFirstFrame[time] = trim[reverse].extfirst
		tool.HoldLastFrame[time]  = trim[reverse].extlast
		
		time = time + cliplen  -- put next clip straight after the previous
	end
	
	composition:EndUndo(true)
end

composition:Unlock()

